import requests

from utils.util import write_json

class Downloader:
    def __init__(self):
        self.ACCESS_TOKEN = ""
        self.headers = {
            "Authorization": f"Bearer {self.ACCESS_TOKEN}"
        }
    
    def get_protocol_list(self, filter="public", order_field="relevance", **params):
        '''
        key <REQ>: string -> search key
        '''
        url = "https://www.protocols.io/api/v3/protocols"
        parameters = {
            "filter": filter, 
            "order_field": order_field,
            **params
        }
        response = self.__download(url, parameters)
        return response

    def get_protocol(self, id):
        url = f"https://www.protocols.io/api/v4/protocols/{id}"
        response = self.__download(url)
        return response

    def __download(self, url, params=None):
        response = requests.get(url=url, headers=self.headers, params=params)

        if response.status_code == 200:
            return response.json()
        else:
            print(response.status_code)
            print(response.text)

    def __extract_protocol_from_list(self, response):
        protocols = []
        protocols.append({"total_results": response["pagination"]["total_results"]})
        for protocol in response.get("items"):
            metadata = {
                "title": protocol["title"],
                "description": protocol["description"]
            }
            protocols.append(metadata)
        return protocols